//+------------------------------------------------------------------+
//|                                                       MA rsi.mq4 |
//|                                      Copyright  2006, Eli hayun |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Eli hayun"
#property link      ""

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Blue
#property indicator_color2 Red
//---- input parameters
extern int       maPeriod=50;
extern int       maMethod=MODE_EMA;
extern int       maPrice=PRICE_CLOSE;
extern int       rsiPeriod=40;
extern int       rsiLevel=50;
//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,ExtMapBuffer2);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {

   int limit;
   int counted_bars=IndicatorCounted();
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
//---- main loop
   for(int i=0; i<limit; i++)
     {
         double ma = iMA(NULL,0,maPeriod, 0, maMethod, maPrice, i);
         double rsi= iRSI(NULL, 0, rsiPeriod, maPrice, i);
         if (rsi >= rsiLevel)
            ExtMapBuffer1[i] = ma;
         else
            ExtMapBuffer2[i] = ma;
     }
   return(0);
  }
//+------------------------------------------------------------------+